<?php

namespace App\Mail;

use App\Models\Ticket;
use App\Models\TicketReply;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TicketReplyMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Ticket $ticket,
        public TicketReply $reply
    ) {}

    public function build()
    {
        return $this->subject('New Reply to Your Ticket: ' . $this->ticket->subject)
                    ->view('emails.ticket-reply')
                    ->with([
                        'ticket' => $this->ticket,
                        'reply' => $this->reply,
                    ]);
    }
}

